/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.max;

import com.cycling74.max.MXJClassLoader;
import com.cycling74.max.MaxSystem;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import jode.decompiler.Decompiler;

public class MXJDecompiler {
    private static Decompiler _decompiler = null;

    private MXJDecompiler() {
    }

    public static MXJDecompiler getInstance() {
        if (_decompiler == null) {
            _decompiler = new Decompiler();
        }
        return new MXJDecompiler();
    }

    public void decompile(String classname, Writer writer) throws IOException {
        this.decompile(classname, MaxSystem.getClassPath(), writer);
    }

    public void decompile(String classname, String[] classpath, Writer writer) throws IOException {
        try {
            String extra = MXJClassLoader.getInstance().getCodeSource(classname);
            if (extra != null) {
                if (extra.endsWith(".class")) {
                    extra = extra.substring(0, extra.lastIndexOf(File.separatorChar));
                }
                String[] classpath2 = new String[classpath.length + 1];
                System.arraycopy(classpath, 0, classpath2, 0, classpath.length);
                classpath2[classpath.length] = extra;
                classpath = classpath2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        _decompiler.setClassPath(classpath);
        _decompiler.decompile(classname, writer, null);
    }
}

